#!/bin/sh
#
# /etc/init.d/shibboleth-identity-provider -- startup script for the shibboleth-identity-provider
#
# Written by Miquel van Smoorenburg <miquels@cistron.nl>.
# Modified for Debian GNU/Linux	by Ian Murdock <imurdock@gnu.ai.mit.edu>.
# Modified for Tomcat by Stefan Gybas <sgybas@debian.org>.
# Modified for Tomcat6 by Thierry Carrez <thierry.carrez@ubuntu.com>.
# Additional improvements by Jason Brittain <jason.brittain@mulesoft.com>.
# Modified for shibboleth-identity-provider by Petra Berg <petra.berg@hu-berlin.de>.
#
### BEGIN INIT INFO
# Provides:          shibboleth-identity-provider
# Required-Start:    $local_fs $remote_fs $network
# Required-Stop:     $local_fs $remote_fs $network
# Should-Start:      $named
# Should-Stop:       $named
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Start shibboleth-identity-provider.
# Description:       Start shibboleth-identity-provider.
### END INIT INFO

set -e

PATH=/bin:/usr/bin:/sbin:/usr/sbin
NAME=shibboleth-identity-provider
DESC="Shibboleth IdP"
DEFAULT=/etc/default/$NAME
JVM_TMP=/tmp/$NAME-tmp

if [ `id -u` -ne 0 ]; then
	echo "You need root privileges to run this script"
	exit 1
fi

# Make sure shibboleth-identity-provider is started with system locale
if [ -r /etc/default/locale ]; then
	. /etc/default/locale
	export LANG
fi

. /lib/lsb/init-functions

if [ -r /etc/default/rcS ]; then
	. /etc/default/rcS
fi


# The following variables can be overwritten in $DEFAULT

# Run shibboleth-identity-provider as this user ID and group ID
SHIB_IDP_USER=shib-idp
SHIB_IDP_GROUP=shib-idp

# The first existing directory is used for JAVA_HOME (if JAVA_HOME is not
# defined in $DEFAULT)
JDK_DIRS="/usr/lib/jvm/default-java /usr/lib/jvm/java-7-openjdk /usr/lib/jvm/java-7-sun"

# Look for the right JVM to use
for jdir in $JDK_DIRS; do
    if [ -r "$jdir/bin/java" -a -z "${JAVA_HOME}" ]; then
	JAVA_HOME="$jdir"
    fi
done
export JAVA_HOME

# Directory where the Tomcat 8 binary distribution resides
CATALINA_HOME=/usr/share/tomcat8

# Directory for per-instance configuration files and webapps
SHIB_IDP_BASE=/var/lib/$NAME

# Use the Java security manager? (yes/no)
TOMCAT8_SECURITY=no

# Default Java options
# Set java.awt.headless=true if JAVA_OPTS is not set so the
# Xalan XSL transformer can work without X11 display on JDK 1.4+
# It also looks like the default heap size of 64M is not enough for most cases
# so the maximum heap size is set to 1024M
if [ -z "$JAVA_OPTS" ]; then
	JAVA_OPTS="-Djava.awt.headless=true -Xmx2048M -Didp.home=/etc/shibboleth-identity-provider"
fi

# End of variables that can be overwritten in $DEFAULT

# overwrite settings from default file
if [ -f "$DEFAULT" ]; then
	. "$DEFAULT"
fi

if [ ! -f "$CATALINA_HOME/bin/bootstrap.jar" ]; then
	log_failure_msg "tomcat8 is not installed"
	exit 1
fi

POLICY_CACHE="$SHIB_IDP_BASE/work/catalina.policy"

if [ -z "$CATALINA_TMPDIR" ]; then
	CATALINA_TMPDIR="$JVM_TMP"
fi

# Set the JSP compiler if set in the tomcat8.default file
if [ -n "$JSP_COMPILER" ]; then
	JAVA_OPTS="$JAVA_OPTS -Dbuild.compiler=\"$JSP_COMPILER\""
fi

SECURITY=""
if [ "$TOMCAT8_SECURITY" = "yes" ]; then
	SECURITY="-security"
fi

# Define other required variables
SHIB_IDP_PID="/var/run/$NAME.pid"
SHIB_IDP_SH="$CATALINA_HOME/bin/catalina.sh"

# Look for Java Secure Sockets Extension (JSSE) JARs
if [ -z "${JSSE_HOME}" -a -r "${JAVA_HOME}/jre/lib/jsse.jar" ]; then
    JSSE_HOME="${JAVA_HOME}/jre/"
fi

catalina_sh() {
	# Escape any double quotes in the value of JAVA_OPTS
	JAVA_OPTS="$(echo $JAVA_OPTS | sed 's/\"/\\\"/g')"
	#log_daemon_msg "JAVA_OPTS" "$JAVA_OPTS\n"

	AUTHBIND_COMMAND=""
	if [ "$AUTHBIND" = "yes" -a "$1" = "start" ]; then
		JAVA_OPTS="$JAVA_OPTS -Djava.net.preferIPv4Stack=true"
		AUTHBIND_COMMAND="/usr/bin/authbind --deep /bin/bash -c "
	fi

	# Define the command to run Tomcat's catalina.sh as a daemon
	# set -a tells sh to export assigned variables to spawned shells.
	# if endorsed is needed pass it by setting JAVA_ENDORSED_DIRS=\"$SHIB_IDP_BASE/endorsed\";
	TOMCAT_SH="set -a; JAVA_HOME=\"$JAVA_HOME\"; source \"$DEFAULT\"; \
		CATALINA_HOME=\"$CATALINA_HOME\"; \
		CATALINA_BASE=\"$SHIB_IDP_BASE\"; \
		JAVA_OPTS=\"$JAVA_OPTS\"; \
		CATALINA_PID=\"$SHIB_IDP_PID\"; \
		CATALINA_TMPDIR=\"$CATALINA_TMPDIR\"; \
		LANG=\"$LANG\"; JSSE_HOME=\"$JSSE_HOME\"; \
		cd \"$SHIB_IDP_BASE\"; \
		\"$SHIB_IDP_SH\" $@"

	#log_daemon_msg "TOMCAT_SH" "$TOMCAT_SH\n"
	if [ "$AUTHBIND" = "yes" -a "$1" = "start" ]; then
		TOMCAT_SH="'$TOMCAT_SH'"
	fi

	# Run the catalina.sh script as a daemon
	set +e
	touch "$SHIB_IDP_PID" "$SHIB_IDP_BASE"/logs/catalina.out
	chown $SHIB_IDP_USER "$SHIB_IDP_PID" "$SHIB_IDP_BASE"/logs/catalina.out
	start-stop-daemon --start -b -u "$SHIB_IDP_USER" -g "$SHIB_IDP_GROUP" \
		-c "$SHIB_IDP_USER" -d "$CATALINA_TMPDIR" -p "$SHIB_IDP_PID" \
		-x /bin/bash -- -c "$AUTHBIND_COMMAND $TOMCAT_SH"
	status="$?"
	set +a -e
	return $status
}

case "$1" in
  start)
	if [ -z "$JAVA_HOME" ]; then
		log_failure_msg "no JDK found - please set JAVA_HOME"
		exit 1
	fi
	#log_daemon_msg "JAVA_HOME" "$JAVA_HOME\n"


	if [ ! -d "$SHIB_IDP_BASE/conf" ]; then
		log_failure_msg "invalid SHIB_IDP_BASE: $SHIB_IDP_BASE"
		exit 1
	fi

	log_daemon_msg "Starting $DESC" "$NAME\n"
	if start-stop-daemon --test --start --pidfile "$SHIB_IDP_PID" \
		--user $SHIB_IDP_USER --exec "$JAVA_HOME/bin/java" \
		>/dev/null; then

		log_progress_msg "Regenerate POLICY_CACHE file\n"
		# Regenerate POLICY_CACHE file
		umask 022
		echo "// AUTO-GENERATED FILE from $SHIB_IDP_BASE/conf/policy.d/*.policy" \
			> "$POLICY_CACHE"
		echo ""  >> "$POLICY_CACHE"
		if [ -d $SHIB_IDP_BASE/conf/policy.d ]; then
			cat $SHIB_IDP_BASE/conf/policy.d/*.policy \
				>> "$POLICY_CACHE"
		fi

		#log_progress_msg "Remove / recreate JVM_TMP directory\n"
		# Remove / recreate JVM_TMP directory
		rm -rf "$JVM_TMP"
		mkdir -p "$JVM_TMP" || {
			log_failure_msg "could not create JVM temporary directory"
			exit 1
		}
		chown $SHIB_IDP_USER "$JVM_TMP"

		log_progress_msg "execute start script: "
		catalina_sh start $SECURITY
		sleep 5
        	if start-stop-daemon --test --start --pidfile "$SHIB_IDP_PID" \
			--user $SHIB_IDP_USER --exec "$JAVA_HOME/bin/java" \
			>/dev/null; then
			if [ -f "$SHIB_IDP_PID" ]; then
				rm -f "$SHIB_IDP_PID"
			fi
			log_end_msg 1
		else
			log_progress_msg "done"
			log_end_msg 0
		fi
	else
	        log_progress_msg "(already running)"
		log_end_msg 0
	fi
	;;
  stop)
	log_daemon_msg "Stopping $DESC" "$NAME"

	set +e
	if [ -f "$SHIB_IDP_PID" ]; then
		start-stop-daemon --stop --pidfile "$SHIB_IDP_PID" \
			--user "$SHIB_IDP_USER" \
			--retry=TERM/20/KILL/5 >/dev/null
		if [ $? -eq 1 ]; then
			log_progress_msg "$DESC is not running but pid file exists, cleaning up"
		elif [ $? -eq 3 ]; then
			PID="`cat $SHIB_IDP_PID`"
			log_failure_msg "Failed to stop $NAME (pid $PID)"
			exit 1
		fi
		rm -f "$SHIB_IDP_PID"
		rm -rf "$JVM_TMP"
	else
		log_progress_msg "(not running)"
	fi
	log_end_msg 0
	set -e
	;;
   status)
	set +e
	start-stop-daemon --test --start --pidfile "$SHIB_IDP_PID" \
		--user $SHIB_IDP_USER --exec "$JAVA_HOME/bin/java" \
		>/dev/null 2>&1
	if [ "$?" = "0" ]; then

		if [ -f "$SHIB_IDP_PID" ]; then
		    log_success_msg "$DESC is not running, but pid file exists."
			exit 1
		else
		    log_success_msg "$DESC is not running."
			exit 3
		fi
	else
		log_success_msg "$DESC is running with pid `cat $SHIB_IDP_PID`"
	fi
	set -e
        ;;
  restart|force-reload)
	if [ -f "$SHIB_IDP_PID" ]; then
		$0 stop
		sleep 1
	fi
	$0 start
	;;
  try-restart)
        if start-stop-daemon --test --start --pidfile "$SHIB_IDP_PID" \
		--user $SHIB_IDP_USER --exec "$JAVA_HOME/bin/java" \
		>/dev/null; then
		$0 start
	fi
        ;;
  *)
	log_success_msg "Usage: $0 {start|stop|restart|try-restart|force-reload|status}"
	exit 1
	;;
esac

exit 0
